

const exportBtn = document.getElementById('export-btn');

const exportMenu = document.getElementById('export-menu');

const togglefilter = document.getElementById('toggleFilterBtn');

const filterForm = document.getElementById('filterContainer');

exportBtn.addEventListener('click', function () {

    exportMenu.style.display = exportMenu.style.display === 'none' ?

        'block' : 'none';

});

togglefilter.addEventListener('click', function () {

    filterForm.classList.toggle('show');

})

document.addEventListener('click', function (event) {

    const isClickInsideExportBtn = exportBtn.contains(event.target);

    const isClickInsideExportMenu = exportMenu.contains(event

        .target);



    if (!isClickInsideExportBtn && !isClickInsideExportMenu) {

        exportMenu.style.display = 'none';

    }

});

document.addEventListener('click', function (event) {

    const isClickInsideFilterBtn = togglefilter.contains(event

        .target);

    const isClickInsideFilterForm = filterForm.contains(event

        .target);

    if (!isClickInsideFilterBtn && !isClickInsideFilterForm) {

        filterForm.classList.remove('show');

    }

});





document.addEventListener("DOMContentLoaded", function () {

    // Set default month to the current month

    var currentMonth = ("0" + (new Date().getMonth() + 1)).slice(-2);

    document.getElementById("filter_Thang").value = currentMonth;



    // Trigger the filter function on page load

    filterTable();

});



function filterTable() {

    var filterMAKH = document.getElementById("filter_MA_KH").value.toUpperCase();

    var filterSoCont = document.getElementById("filter_nha_xe").value.toUpperCase();

    var filterNgayGhiSo = document.getElementById("filter_Ngay_ghi_so").value.toUpperCase();

    var filterThang = document.getElementById("filter_Thang").value;



    var table = document.getElementById("myTable");

    var tr = table.getElementsByTagName("tr");



    for (var i = 1; i < tr.length; i++) {

        var tdMAKH = tr[i].getElementsByTagName("td")[1];

        var tdSoCont = tr[i].getElementsByTagName("td")[3];

        var tdNgayGhiSo = tr[i].getElementsByTagName("td")[2];



        if (tdMAKH && tdSoCont && tdNgayGhiSo) {

            var txtValueMAKH = tdMAKH.textContent || tdMAKH.innerText;

            var txtValueSoCont = tdSoCont.textContent || tdSoCont.innerText;

            var txtValueNgayGhiSo = tdNgayGhiSo.textContent || tdNgayGhiSo.innerText;



            var date = new Date(txtValueNgayGhiSo);

            var month = ("0" + (date.getMonth() + 1)).slice(-2);



            if ((txtValueMAKH.toUpperCase().indexOf(filterMAKH) > -1 || filterMAKH === "") &&

                (txtValueSoCont.toUpperCase().indexOf(filterSoCont) > -1 || filterSoCont === "") &&

                (txtValueNgayGhiSo.toUpperCase().indexOf(filterNgayGhiSo) > -1 || filterNgayGhiSo === "") &&

                (month === filterThang || filterThang === "")) {

                tr[i].style.display = "";

            } else {

                tr[i].style.display = "none";

            }

        }

    }

}



function searchTable() {

    let input = document.getElementById('searchInput').value.toLowerCase();

    let table = document.getElementById('myTable');

    let trs = table.getElementsByTagName('tr');



    for (let i = 1; i < trs.length; i++) {

        let tds = trs[i].getElementsByTagName('td');

        let rowContainsSearchTerm = false;



        for (let j = 0; j < tds.length; j++) {

            if (tds[j].innerText.toLowerCase().includes(input)) {

                rowContainsSearchTerm = true;

                break;

            }

        }



        if (rowContainsSearchTerm) {

            trs[i].style.display = "";

        } else {

            trs[i].style.display = "none";

        }

    }

}



function updateFilters() {

    let maKHSelect = document.getElementById('filter_MA_KH');

    let soContSelect = document.getElementById('filter_nha_xe');

    let ngayGhiSoSelect = document.getElementById('filter_Ngay_ghi_so');

    let table = document.getElementById('myTable');

    let trs = table.getElementsByTagName('tr');



    let soContOptions = new Set();

    let ngayGhiSoOptions = new Set();



    for (let i = 1; i < trs.length; i++) {

        let cells = trs[i].getElementsByTagName('td');

        let maKHCell = cells[1].innerText;

        let soContCell = cells[3].innerText;

        let ngayGhiSoCell = cells[2].innerText;



        if (maKHCell === maKHSelect.value) {

            soContOptions.add(soContCell);

            ngayGhiSoOptions.add(ngayGhiSoCell);

        }

    }



    soContSelect.innerHTML = '<option value="">Chọn</option>';

    ngayGhiSoSelect.innerHTML = '<option value="">Chọn</option>';



    soContOptions.forEach(option => {

        soContSelect.innerHTML +=

            `<option value="${option}">${option}</option>`;

    });



    ngayGhiSoOptions.forEach(option => {

        ngayGhiSoSelect.innerHTML +=

            `<option value="${option}">${option}</option>`;

    });

}





function exportToPDF() {

    const table = document.getElementById('myTable');

    const rows = Array.from(table.querySelectorAll('tr'));



    const docDefinition = {

        content: [

            {

                table: {

                    headerRows: 1,

                    widths: Array(21).fill('*'), // Adjust column width here if needed

                    body: [

                        [

                            {text: 'STT', style: 'tableHeader'},

                            {text: 'Ngày ghi sổ', style: 'tableHeader'},

                            {text: 'Số cont', style: 'tableHeader'},

                            {text: 'Điểm lấy rỗng', style: 'tableHeader'},

                            {text: 'Điểm đóng hàng', style: 'tableHeader'},

                            {text: 'Điểm giao hàng', style: 'tableHeader'},

                            {text: 'Giá vận chuyển', style: 'tableHeader'},

                            {text: 'VAT', style: 'tableHeader'},

                            {text: 'CHI HỘ', style: 'tableHeader'},

                            {text: '', style: 'tableHeader'},

                            {text: '', style: 'tableHeader'},

                            {text: 'Phải thu', style: 'tableHeader'},

                            {text: 'SỐ XE', style: 'tableHeader'},

                            {text: 'TÀI XẾ', style: 'tableHeader'},

                            {text: 'Ghi chú', style: 'tableHeader'},

                            {text: '', style: 'tableHeader'},

                            {text: 'Phí nâng', style: 'tableHeader'},

                            {text: 'Phí hạ', style: 'tableHeader'},

                            {text: 'Phí khác', style: 'tableHeader'},

                            {text: '', style: 'tableHeader'},

                            {text: '', style: 'tableHeader'},

                        ]

                    ].concat(

                        rows.map((row, index) => {

                            const cells = Array.from(row.querySelectorAll('th, td'));

                            return [

                                {text: index + 1, style: 'tableBody'},

                                ...cells.map(cell => ({text: cell.innerText, style: 'tableBody'}))

                            ];

                        })

                    )

                }

            }

        ],

        styles: {

            tableHeader: {

                bold: true,

                fontSize: 12,

                fillColor: '#f2f2f2',

                alignment: 'center'

            },

            tableBody: {

                fontSize: 10,

                alignment: 'center'

            }

        }

    };



    pdfMake.createPdf(docDefinition).download('table.pdf');

}





function exportSelectedRowsToExcel() {

    const selectedRows = [];

    const checkboxes = document.querySelectorAll('.rowselect:checked');



    checkboxes.forEach(checkbox => {

        selectedRows.push(parseInt(checkbox.value));

    });



    if (selectedRows.length === 0) {

        const totalRows = document.querySelectorAll('#myTable tbody tr').length;

        for (let i = 0; i < totalRows; i++) {

            selectedRows.push(i);

        }

    }



    const headers = [

        ["MÃ KH", "Ngày ghi sổ", "Số cont", "Điểm lấy rỗng", "Điểm đóng hàng", "Điểm giao hàng","Xuất Nhập","Loại Cont", "Giá vận chuyển", "VAT", "CHI HỘ", "", "","","","","","", "Phải thu","Đã Thu", "Thuê Xe Ngoài","", "Xe Nhà","","Chi Phí Phát Sinh","Hoa Hồng","Tổng Chi Phí", "Ghi chú"],

        ["", "", "", "", "", "", "", "","","", "Phí Bốc Xếp", "Phí nâng", "Phí hạ","Vệ Sinh","Cân","Cược cont","Neo", "Phí khác", "", "", "Nhà Xe", "Giá","Tên","Số Xe","","","",""]

    ];



    const table = document.getElementById('myTable');

    const rows = Array.from(table.querySelectorAll('tbody tr')).map((tr, index) => {

        if (selectedRows.includes(index)) {

            const ma_kh = tr.querySelector('td:nth-child(2) a').textContent.trim();

            const cells = tr.cells;

            return [

                ma_kh, // MÃ KH

                cells[3].innerText.trim(), // Ngày ghi sổ

                cells[2].innerText.trim(), // Số cont

                cells[4].innerText.trim(), // Điểm lấy rỗng

                cells[5].innerText.trim(), // Điểm đóng hàng

                cells[6].innerText.trim(), // Điểm giao hàng

                cells[7].innerText.trim(), // Xuất Nhập

                cells[8].innerText.trim(), // Loại Cont

                cells[9].innerText.trim(), // Giá vận chuyển

                cells[10].innerText.trim(), // VAT

                cells[11].innerText.trim(),//Phí Bốc Xếp

                cells[12].innerText.trim(), // Phí nâng

                cells[13].innerText.trim(),// Phí hạ

                cells[14].innerText.trim(), //Vệ Sinh Cân

                cells[15].innerText.trim(), // Cược cont

                cells[16].innerText.trim(), // Neo

                cells[17].innerText.trim(), // Phí khác

                cells[18].innerText.trim(), // Phải thu

                cells[19].innerText.trim(), // Đã Thu

                cells[20].innerText.trim(), // Thuê Xe Ngoài

                cells[21].innerText.trim(), // Nhà Xe

                cells[22].innerText.trim(), // SỐ XE

                cells[23].innerText.trim(), // TÀI XẾ

                cells[24].innerText.trim(), // Chi Phí Phát Sinh

                cells[25].innerText.trim(), // Hoa Hồng

                cells[26].innerText.trim(), // Tọng Chi Phí

                cells[27].innerText.trim(),  // Ghi chú

                cells[28].innerText.trim(), // Giá

            ];

        }

    }).filter(row => row !== undefined);

    let customerName = "";

    if (rows.length > 0) {

        customerName = rows[0][0]; // First column of the first selected row

    }

    let datetime="";

    if (rows.length > 0) {

        let [_, month, year] = rows[0][1].split('/');

        datetime = `${month}/${year}`;

    }

    const titles = [

        ["CÔNG TY TNHH TIẾP VẬN TÍN PHÁT"],

        ["Địa chỉ : 25/18/25 Nguyễn Minh Châu, phường Phú Trung, Quận Tân Phú, TP.HCM"],

        ["MST : 0314 715 231"],

        [`SỔ CHI TIẾT CÔNG NỢ - ${customerName} (Tháng ${datetime} )`],

        [],

        []

    ];



    const totalCols = headers[0].length;

    const lastCols = [totalCols - 2, totalCols - 3, totalCols - 4, totalCols - 7, totalCols - 9, totalCols - 10, totalCols - 11, totalCols - 12, totalCols - 13, totalCols - 14, totalCols - 15, totalCols - 16, totalCols - 17, totalCols - 18, totalCols - 19,totalCols - 20];

    const chiHoCols = [totalCols - 11, totalCols - 12, totalCols - 13, totalCols - 14, totalCols - 15, totalCols - 16, totalCols - 17, totalCols - 18, totalCols - 19];

    let totalValues = Array(totalCols).fill(0);

    let totalChiHo = 0;

    

    rows.forEach(row => {

        lastCols.forEach(col => {

            if (row[col]) totalValues[col] += parseFloat(row[col].replace(/,/g, ""));

        });

    

        chiHoCols.forEach(col => {

            if (row[col]) totalChiHo += parseFloat(row[col].replace(/,/g, ""));

        });

    });

    

    const totalRow = Array(totalCols).fill("");

    totalRow[0] = "Tổng cộng";

    lastCols.forEach(col => {

        totalRow[col] = totalValues[col].toFixed(0).replace(/\B(?=(\d{3})+(?!\d))/g, ",");

    });

    

    const totalChiHoRow = Array(totalCols).fill("");

    totalChiHoRow[15] = "Tổng chi hộ";

    totalChiHoRow[chiHoCols[0]] = totalChiHo.toFixed(0).replace(/\B(?=(\d{3})+(?!\d))/g, ",");

    

    const totalVanchuyen = Array(totalCols).fill("");

    totalVanchuyen[15] = "Tổng vận chuyển";

    totalVanchuyen[chiHoCols[0]] = totalValues[totalCols - 20].toFixed(0).replace(/\B(?=(\d{3})+(?!\d))/g, ",");

    

    const tamUng = Array(totalCols).fill("");

    tamUng[15] = "Tạm Ứng";

    

    const tinhConLai = Array(totalCols).fill("");

    tinhConLai[15] = "Còn Lại";

    

    const data = [...titles, ...headers, ...rows, totalRow, [], totalVanchuyen, totalChiHoRow, tamUng, tinhConLai];

    

    



    for (let i = 0; i < data.length; i++) {

        if (lastCols.includes(i)) {

            data[i].s = { t: 's', r: i+8, c: i, h: null, w: '100' };

            data[i].z = { font: { sz: 12, color: { rgb: '00B050' }, underline: true } };

        }

    }

    const wb = XLSX.utils.book_new();

    const ws = XLSX.utils.aoa_to_sheet(data);



    ws['!merges'] = [

        { s: { r: 0, c: 0 }, e: { r: 0, c: 14 } }, // Merge title row 1

        { s: { r: 1, c: 0 }, e: { r: 1, c: 14 } }, // Merge title row 2

        { s: { r: 2, c: 0 }, e: { r: 2, c: 14 } }, // Merge title row 3

        { s: { r: 3, c: 0 }, e: { r: 3, c: 14 } }, // Merge title row 4

        { s: { r: 4, c: 0 }, e: { r: 4, c: 14 } }, // Merge title row 5

        { s: { r: 6, c: 10 }, e: { r: 6, c: 17 } },  // Merge "CHI HỘ" header

        { s: { r: 6, c: 20 }, e: { r: 6, c: 21 } },  // Merge "Thuê Xe Ngoài" header

        { s: { r: 6, c: 22 }, e: { r: 6, c: 23 } }

    ];



    for (let i = 0; i < 5; i++) {

        const cellAddress = XLSX.utils.encode_cell({ r: i, c: 0 });

        if (!ws[cellAddress]) ws[cellAddress] = {};

        ws[cellAddress].s = {

            font: { bold: true, sz: 14 },

            alignment: { horizontal: 'center', vertical: 'center' }

        };

    }



    const headerRow1 = 6;

    const headerRow2 = 7;

    headers[0].forEach((header, colIdx) => {

        const cellAddress = XLSX.utils.encode_cell({ r: headerRow1, c: colIdx });

        if (!ws[cellAddress]) ws[cellAddress] = {};

        ws[cellAddress].s = {

            fill: { fgColor: { rgb: "A9D08E" } }, // Green background

            font: { bold: true },

            alignment: { horizontal: 'center', vertical: 'center' }

        };

    });



    headers[1].forEach((header, colIdx) => {

        const cellAddress = XLSX.utils.encode_cell({ r: headerRow2, c: colIdx });

        if (!ws[cellAddress]) ws[cellAddress] = {};

        ws[cellAddress].s = {

            fill: { fgColor: { rgb: "A9D08E" } }, // Green background

            font: { bold: true },

            alignment: { horizontal: 'center', vertical: 'center' }

        };

    });



    headers[1].forEach((header, colIdx) => {

        if (header === "") {

            const startCell = XLSX.utils.encode_cell({ r: headerRow1, c: colIdx });

            const endCell = XLSX.utils.encode_cell({ r: headerRow2, c: colIdx });

            ws['!merges'].push({ s: { r: headerRow1, c: colIdx }, e: { r: headerRow2, c: colIdx } });

            if (!ws[startCell]) ws[startCell] = {};

            ws[startCell].s = {

                alignment: { horizontal: 'center', vertical: 'center' }

            };

        }

    });



    XLSX.utils.book_append_sheet(wb, ws, 'SelectedRows');

    XLSX.writeFile(wb,  `Sổ Chi Tiết Công Nợ - ${customerName} (${datetime}).xlsx`);

}







function printTable() {

    const printContents = document.getElementById('myTable').outerHTML;

    const originalContents = document.body.innerHTML;



    document.body.innerHTML = printContents;

    window.print();

    document.body.innerHTML = originalContents;

}



// JavaScript để xử lý hiệu ứng và sự kiện khi nhấn nút

document.addEventListener('DOMContentLoaded', function () {

    var formContainer = document.querySelector('.form-container');

    var addButton = document.querySelector('#add-button');



    addButton.addEventListener('click', function () {

        formContainer.classList.toggle('show');

        formContainer.style.display = 'block';

    });

});











function submitForm() {

    document.getElementById("filterForm").submit();

}



function resetFilters() {

    // Lấy giá trị của tháng đã chọn

    var selectedMonth = $('#ngay_thang').val();

    var records_per_page = $('#recordsPerPage').val();



    // Reset các dropdown Ten_KH và nha_xe

    $('#ten_kh').html('<option value="">Chọn Tên KH</option>');

    $('#nha_xe').html('<option value="">Chọn Số Cont</option>');



    // Cập nhật URL để chỉ giữ lại tháng đã chọn

    var newUrl = window.location.origin + window.location.pathname;

    if (selectedMonth) {

        newUrl += '?ngay_thang=' + selectedMonth + '&records_per_page=' + records_per_page;

    }

    window.location.href = newUrl;

}



document.querySelectorAll('.truncate').forEach(function (element) {

    element.addEventListener('transitionend', function () {

        if (element.classList.contains('truncate')) {

            element.classList.remove('truncate');

        }

    });

});





$('.color-selector').click(function () {

    $('.color-options').toggle();

});

$('.color-option').click(function () {

    var color = $(this).css('background-color');

    $('.color-selected').css({ 'background-color': color, 'display': 'block' });



    $('.color-options').hide();

});







// Trong scripts.js



$(document).ready(function() {

    var selectedColor = '';



    $('.color-option').on('click', function() {

        selectedColor = $(this).css('background-color');

        $('.color-option').removeClass('selected');

        $(this).addClass('selected');

    });



    $('tr').on('click', function() {

        var row = $(this);

        var id = row.data('id');

        var currentColor = row.css('background-color');



        if (selectedColor && currentColor === 'rgba(0, 0, 0, 0)') {

            // Apply color to row and mark it as selected

            row.css('background-color', selectedColor);

            updateRowColor(id, selectedColor);

            row.addClass('selected');

            row.find('td').css('color', 'white');

        } else if (currentColor !== 'rgba(0, 0, 0, 0)') {

            // Remove color if row is already colored and clicked again

            row.css('background-color', '');

            updateRowColor(id, ''); // Send empty color to remove from database

            row.removeClass('selected');

            row.find('td').css('color', '#64748b');

        }

    });



    $('tr').each(function() {

        var row = $(this);

        var currentColor = row.css('background-color');

        if (currentColor !== 'rgba(0, 0, 0, 0)') {

            row.find('td').css('color', 'white');

        }

    });







    $('#ten_kh').change(function() {

        updateSoCont();

    });



    function updateSoCont() {

        var selectedTenKH = $('#ten_kh').val();

        var selectedMonth = $('#ngay_thang').val();

        var soContOptions = '';



        $.ajax({

            url: 'get_nha_xe.php', // Đường dẫn đến tệp PHP để lấy dữ liệu.

            method: 'POST',

            data: {

                selectedTenKH: selectedTenKH,

                selectedMonth: selectedMonth

            },

            success: function(response) {

                // Xử lý dữ liệu nhận được từ máy chủ và cập nhật dropdown nha_xe.

                $('#nha_xe').html('<option value="">Chọn Số Cont</option>' + response);

            },

            error: function() {

                console.error('Error updating nha_xe dropdown.');

            }

        });

    }



    // Initialization code

    if (!$('#ngay_thang').val()) {

        $('#ngay_thang').val('<?php echo $current_month; ?>');

    }

});



function updateRowColor(id, color) {

    $.ajax({

        url: 'template_module1/update_row_color', // Đường dẫn đến tệp PHP xử lý cập nhật màu.

        method: 'POST',

        data: {

            id: id,

            color: color,

        },

        success: function(response) {

            console.log('Color updated successfully');

        },

        error: function() {

            console.error('Error updating color');

        }

    });

}

setTimeout(function() {

    $("#success-alert").fadeOut(300, function(){

        $(this).remove();

    });

}, 3000);