<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Công Nợ ( admin only)
Description: Công Nợ ( admin only)
Version: 1.0.0
Requires at least: 2.3.*
Author: Bao
*/

define('CONGNO_NAME', 'congno');

hooks()->add_action('admin_init', 'congno_init_menu_items');
hooks()->add_action('customers_navigation_end', 'customers_navigation_congno');

/**
 * Register activation module hook
 */
register_activation_hook(CONGNO_NAME, 'congno_activation_hook');

function congno_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}



/**
 * Init template module 1 menu items in setup in admin_init hook
 * @return null
 */
function congno_init_menu_items()
{
    /**
     * If the logged-in user is an administrator, add a custom menu in Setup
     */
    if (is_admin()) {
        $CI = &get_instance();

        $CI->app_menu->add_sidebar_menu_item('congno_menu', [
            'name'     => _l('Công Nợ ( admin only)'),
            'href'     => admin_url('congno'),
            'icon'     => 'fa fa-credit-card',
            'position' => 5,
        ]);
    }
}
