<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Template_module extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Model_luong');
    }

    public function index()
    {
        if ($this->input->post()) {
            $data = $this->input->post();
            $this->Model_luong->insert_luong($data);
            redirect(current_url());
        }

        $data['clients'] = $this->Model_luong->get_clients();
        $data['luong_data'] = $this->Model_luong->get_luong_data();
        $data['staff'] = $this->Model_luong->get_staff_data();
        $data['success_message'] = $this->session->flashdata('success_message');
        $data['error'] = $this->session->flashdata('error');
        $data['congno'] = $this->Model_luong->get_congno();
        $data['xenha'] = $this->Model_luong->get_xenha();
        $this->load->view('manage', $data);
    }


    public function delete($id)
    {
        $this->Model_luong->delete_luong($id);
        redirect('template_module/index');
    }
    public function update_row_color()
    {
        $id = $this->input->post('id');
        $color = $this->input->post('color');
    
        $this->Model_luong->update_field($id, 'note_color', $color);
        $csrf_hash = $this->security->get_csrf_hash(); // Lấy mã thông báo CSRF mới
    
        echo json_encode(['status' => 'success', 'csrfHash' => $csrf_hash]);
    }
    public function get_luong($id)
    {
        $luong = $this->Model_luong->get_luong_by_id($id);
        echo json_encode($luong);
    }

    public function update_luong()
    {
        $id = $this->input->post('id');
        $data = $this->input->post();
        $this->Model_luong->update_luong($id, $data);
        echo json_encode(['status' => 'success']);
    }
}
